drop function if exists public.ufd_est_prod_tbl_desc_qtde(integer, integer, integer, integer, double precision, integer);
drop function if exists public.ufd_est_prod_tbl_desc_qtde(integer, integer, integer, integer, double precision, integer, integer);


do $$
begin
	if exists (select 1 from pg_type where typname = 'rs_tab_desc_qtde_acima') then
		drop type public.rs_tab_desc_qtde_acima cascade;
	end if;
end$$;

create type public.rs_tab_desc_qtde_acima as
(   cd_tbl_desc   integer,
    tp_desc       integer,
    flag_desc_fix integer,
    perc_desc     double precision,
    perc_desc_max double precision,
    tp_nivel      integer,
	agregacao     integer
);
	
alter type public.rs_tab_desc_qtde_acima
  owner to postgres;


grant usage on type public.rs_tab_desc_qtde_acima to public;

  
CREATE OR REPLACE FUNCTION public.ufd_est_prod_tbl_desc_qtde(
	integer, 
	integer, 
	integer, 
	integer, 
	double precision, 
	integer, 
	integer, 
	INTEGER
)
RETURNS SETOF public.rs_tab_desc_qtde_acima AS
$body$

/*  
function: select * from ufd_est_prod_tbl_desc_qtde(1, 4, 1, 1, 5, 0,2)
=======================================================================================
'Nível Classificação.: INFORMAÇÃO RESTRITA
'Versão..............: 20221106
'Job.................:  
'Nome................: rs_tab_desc_qtde_acima
'Objetivo............: 
'Tabelas.............: 
'Dt Criação..........: 
'Dt Ult Alteracão....: 2022-11-06
'Alterado por........: Marcos barros
'Criado por..........: 
'=======================================================================================
*/

declare
---------------------------------------------------------
----declara as variaveis que estao no cabecalho da funcao
---------------------------------------------------------
int_cd_emp              alias for $1;
int_cd_filial           alias for $2; 
int_cd_cli              alias for $3;
int_cd_prod             alias for $4;
int_qtde_produto        alias for $5;
int_is_receita          alias for $6;
int_cd_forma_pgto       alias for $7;
int_usa_desconto_propz_ident ALIAS FOR $8;
---------------------------------------------------------
---fim
---------------------------------------------------------

vr_tp_cliente 		integer array;
vr_cli_conv    		integer;
vr_cli_cred    		integer;
var_cli_fidelidade 	integer;

var_desc_multiplo 	integer;
var_trabalhacomdescontoformadepagamento 	integer;


returnrec rs_tab_desc_qtde_acima; --recebera os dados de retorno da funcao


--declarando variavel para teste da flag 
begin --inicio dos blocos da funcao
	vr_tp_cliente = array [0]; -- 0 comum, 1 convenio, 2 crediario , 3 crediario e convneio , 4 fidelidade
	vr_cli_conv = 0; 		   -- 0 false 1 true
	vr_cli_cred = 0;		   -- 0 false 1 true
	var_cli_fidelidade = 0;    -- 0 false 1 true
	
	-------------------------------------------------------------------------------------------------------------------------------
	--declarando tabela temporaria de retorno
	-------------------------------------------------------------------------------------------------------------------------------
	begin
		create temporary table temp_rs_tab_desc_qtde
		(	
			cd_tbl_desc 		integer,
			tp_desc 			integer,
			flag_desc_fix 		integer,
			perc_desc			double precision,
			perc_desc_max		double precision,
			tp_nivel			integer,
			dt_ini              timestamp without time zone,
			qtde			    integer,
			multiplos           integer,
			agregacao           integer
		);
		exception when others then
		truncate table temp_rs_tab_desc_qtde; -- trunca a tabela se ela já existir na corrente sessão.
	end;
	-------------------------------------------------------------------------------------------------------------------------------
	--declarando tabela que recebera as tbls vigentes
	-------------------------------------------------------------------------------------------------------------------------------
	begin
		create temporary table rs_tab_ativa_qtde
		(	
			cd_emp 		integer,    
			cd_tbl_desc integer,    
			tp_desc 	integer
		);
		exception when others then
		truncate table rs_tab_ativa_qtde; -- trunca a tabela se ela ja existir na corrente sessao.
	end;
	-------------------------------------------------------------------------------------------------------------------------------
	--declarando tabela de arvore mercadologica do produto
	-------------------------------------------------------------------------------------------------------------------------------
	begin
		create temporary table rs_est_prod_arv_merc
		(
			cd_emp					integer,
			cd_prod					integer,
			cd_arv_merc_categ		integer,
			cd_arv_merc_linha		integer,
			cd_mc					integer,
			cd_arv_merc_familia		integer,								
			cd_fabric				integer
		);--fim rs_est_prod_arv_merc
		exception when others then
		truncate table rs_est_prod_arv_merc; -- trunca a tabela se ela ja existir na corrente sessao.
	end;
	-------------------------------------------------------------------------------------------------------------------------------	
	---------------------------------------------------fim da criacao das tbls temporarias-----------------------------------------
	-------------------------------------------------------------------------------------------------------------------------------
	-------------------------------------------------------------------------------------------------------------------------------
	--buscando arvore merc. do produto
	-------------------------------------------------------------------------------------------------------------------------------	
	insert into rs_est_prod_arv_merc		
		select 
			arv.cd_emp					,
			arv.cd_prod					,
			arv.cd_arv_merc_categ		,
			arv.cd_arv_merc_linha		,
			arv.cd_mc					,
			arv.cd_arv_merc_familia		,												
			p.cd_fabric 
		from 	est_prod_est_arv_mercadologica arv inner join est_prod p on
				arv.cd_emp		= p.cd_emp
				and arv.cd_prod = p.cd_prod
		where   	arv.cd_emp = int_cd_emp
			and 	arv.cd_prod = int_cd_prod;
			
			
	var_trabalhacomdescontoformadepagamento = coalesce((select coalesce(valor,'0')::integer from prc_filial_config where cd_chave = 'USA_DESCONTO_PGTO' and cd_filial = int_cd_filial), 0);

	
	-- verificando se cliente e um cliente conveniado
	vr_cli_conv = coalesce((select 1 from rc_cli_conv_rc_cli where int_cd_cli = cd_cli and sts_cred = 0 and sts_ativo = 0 limit 1), 0);
	
	
	-- verificando se cliente e um cliente crediario
	vr_cli_cred = coalesce((select 1 
						      from rc_cli c 
						           inner join rc_cli_crediario cr on c.cd_cli = cr.cd_cli
						     where int_cd_cli = c.cd_cli 
							   and c.flag_cliente_crediario = 0 
							   and cr.sts_cred = 0 
							   and coalesce(cr.cd_mot_bloq_cli, 0) = 0), 0);
	
	
    -- verificando se cliente e fidelidade
	var_cli_fidelidade	= coalesce((select coalesce(flag_cli_fidel,0) from rc_cli where cd_emp = int_cd_emp and cd_cli = int_cd_cli),0);	
 	
							   

	-- avaliando tipo de cliente
	if var_cli_fidelidade > 0 then
	
		if vr_cli_conv = 1 then 
			vr_tp_cliente = array[0,1,3,4]; -- cliente e convenio e fidelidade
			
			if vr_cli_cred = 1 then
				vr_tp_cliente = array[0,1,2,3,4]; -- cliente e crediario e convenio 
			end if;
		else
			if vr_cli_cred = 1 then
				vr_tp_cliente = array[0,2,3,4]; -- cliente eh crediario e fidelidade
			else
				vr_tp_cliente = array[0,4]; 
			end if;
		end if;

	else
	
		if vr_cli_conv = 1 then 
			vr_tp_cliente = array[0,1,3]; -- cliente eh convenio
			if vr_cli_cred = 1 then
				vr_tp_cliente = array[0,1,2,3]; -- cliente eh crediario e convenio
			end if;
		else
			if vr_cli_cred = 1 then
				vr_tp_cliente = array[0,2,3]; -- cliente eh crediario
			end if;
		end if;
	end if;
	
	

	if exists (select 1 from rs_est_prod_arv_merc) then
	
		-- todas as tabelas que nao exite receita
		insert into rs_tab_ativa_qtde    
			select  a.cd_emp,    
					a.cd_tbl_desc,    
					a.cd_tp_desconto
			from est_prod_tbl_desc a  inner join
				 est_prod_tbl_desc_prc_filial fil on    
					a.cd_emp = fil.cd_emp and    
					a.cd_tbl_desc = fil.cd_tbl_desc
			where	int_cd_emp = a.cd_emp and 
					int_cd_filial = fil.cd_filial and
					current_date between cast(a.dt_ini as date) and cast(a.dt_fim as date) and
					1 = a.sts_tbl_desc and    
					14 = a.cd_tp_desconto and
					a.flag_desc_receita = 0
					AND	(
					  ((int_usa_desconto_propz_ident = 1) AND (a.flag_tp_desconto_propz = 1)) OR 
					  ((int_usa_desconto_propz_ident = 0) AND (a.flag_tp_desconto_propz <> 1))
					);
					
					
		-- inclui as tabelas que exite receita			
		if 	int_is_receita > 0 then		
			insert into rs_tab_ativa_qtde    
				select  a.cd_emp,    
						a.cd_tbl_desc,    
						a.cd_tp_desconto
				from est_prod_tbl_desc a inner join
					 est_prod_tbl_desc_prc_filial fil on    
						a.cd_emp = fil.cd_emp and    
						a.cd_tbl_desc = fil.cd_tbl_desc
				where	int_cd_emp = a.cd_emp and      
						int_cd_filial = fil.cd_filial and
						current_date between cast(a.dt_ini as date) and cast(a.dt_fim as date) and
						1 = a.sts_tbl_desc and    
						14 = a.cd_tp_desconto and 
						a.flag_desc_receita = 1
						AND	(
					      ((int_usa_desconto_propz_ident = 1) AND (a.flag_tp_desconto_propz = 1)) OR 
					      ((int_usa_desconto_propz_ident = 0) AND (a.flag_tp_desconto_propz <> 1))
					    );
		end if;
		
		
	--raise notice 'var_trabalhacomdescontoformadepagamento %.',var_trabalhacomdescontoformadepagamento;
	
	  if var_trabalhacomdescontoformadepagamento = 1 then  
			 
	
			delete from rs_tab_ativa_qtde a 
			 where not exists (select b.cd_emp
			      				 from est_prod_tbl_desc_forma_pgto b  
				    			where b.cd_emp        = a.cd_emp
				    			  and b.cd_tbl_desc   = a.cd_tbl_desc   
				    			  and b.cd_forma_pgto = int_cd_forma_pgto  
				    			    ) ;
	
		end if ; 

         
	
		
		if exists (select 1 from rs_tab_ativa_qtde) then
			-------------------------------------------------------------------------------------------------------------------------------    
			--consultando as tbls de desconto para verificar se ha algum desconto no nivel 1 - produtos    
			-------------------------------------------------------------------------------------------------------------------------------    
			insert into temp_rs_tab_desc_qtde     
				  select    
						a.cd_tbl_desc as cd_tbl_desc,    
						a.cd_tp_desconto as tp_desc,    
						a.flag_desc_fix,    
						b.perc_desc as perc_desc,    
						b.perc_desc_max as perc_desc_max,    --vr_tp_cliente
						1 as tp_nivel,
						a.dt_ini,
						e.qtde_acima,
						a.flag_aplica_desconto_qtde_multiplo,
						a.flag_agregar_desc_qtde_aos_descontos_existentes
				  from est_prod_tbl_desc a
						inner join est_prod_tbl_desc_qtde_acima e on
							a.cd_emp = e.cd_emp and    
							a.cd_tbl_desc = e.cd_tbl_desc 
						inner join est_prod_tbl_desc_est_prod b on    
							a.cd_emp = b.cd_emp and    
							a.cd_tbl_desc = b.cd_tbl_desc    
						inner join est_prod_tbl_desc_prc_filial fil on    
							b.cd_emp = fil.cd_emp and    
							b.cd_tbl_desc = fil.cd_tbl_desc    
						inner join rs_tab_ativa_qtde on    
							b.cd_emp = rs_tab_ativa_qtde.cd_emp and    
							b.cd_tbl_desc = rs_tab_ativa_qtde.cd_tbl_desc     
						inner join rs_est_prod_arv_merc arv on    
							b.cd_emp = arv.cd_emp and    
							b.cd_prod = arv.cd_prod           
				  where     
							int_cd_filial = fil.cd_filial and
							int_qtde_produto >= e.qtde_acima and
							e.tp_cliente in ( select * from unnest(vr_tp_cliente));
			--raise notice 'perc_desc 1 %', (select perc_desc from temp_rs_tab_desc_qtde limit 1);
			
			
			-------------------------------------------------------------------------------------------------------------------------------    
			--consultando as tbls de desconto para verificar se ha algum desconto no nivel 2 - familias    
			-------------------------------------------------------------------------------------------------------------------------------    
			insert into temp_rs_tab_desc_qtde     
				select   
					a.cd_tbl_desc as cd_tbl_desc,    
					a.cd_tp_desconto as tp_desc,    
					a.flag_desc_fix,    
					b.perc_desc as perc_desc,    
					b.perc_desc_max as perc_desc_max,   
					2 as tp_nivel,
					a.dt_ini    ,
					e.qtde_acima,
					a.flag_aplica_desconto_qtde_multiplo,
					a.flag_agregar_desc_qtde_aos_descontos_existentes
				from est_prod_tbl_desc a
						inner join est_prod_tbl_desc_qtde_acima e on
							a.cd_emp = e.cd_emp and    
							a.cd_tbl_desc = e.cd_tbl_desc
						inner join est_prod_tbl_desc_est_arv_merc_familia b on    
							a.cd_emp = b.cd_emp and    
							a.cd_tbl_desc = b.cd_tbl_desc    
						inner join est_prod_tbl_desc_prc_filial fil on    
							b.cd_emp = fil.cd_emp and    
							b.cd_tbl_desc = fil.cd_tbl_desc    
						inner join rs_est_prod_arv_merc arv on    
							b.cd_emp = arv.cd_emp and    
							b.cd_arv_merc_familia = arv.cd_arv_merc_familia    
						inner join rs_tab_ativa_qtde on    
							a.cd_emp = rs_tab_ativa_qtde.cd_emp and    
							b.cd_tbl_desc = rs_tab_ativa_qtde.cd_tbl_desc        
				where     
						int_cd_filial = fil.cd_filial and
						int_qtde_produto >= e.qtde_acima and
						e.tp_cliente in ( select * from unnest(vr_tp_cliente));
			--raise notice 'perc_desc 2 %', (select perc_desc from temp_rs_tab_desc_qtde limit 1);
			
			
			-------------------------------------------------------------------------------------------------------------------------------        
			--consultando as tbls de desconto para verificar se ha algum desconto no nivel 3 - marcas    
			-------------------------------------------------------------------------------------------------------------------------------    
			insert into temp_rs_tab_desc_qtde     
				select
					a.cd_tbl_desc as cd_tbl_desc,    
					a.cd_tp_desconto as tp_desc,    
					a.flag_desc_fix,    
					b.perc_desc as perc_desc,    
					b.perc_desc_max as perc_desc_max,   
					3 as tp_nivel,
					a.dt_ini    ,
					e.qtde_acima,
					a.flag_aplica_desconto_qtde_multiplo,
					a.flag_agregar_desc_qtde_aos_descontos_existentes
				from est_prod_tbl_desc a
					inner join est_prod_tbl_desc_qtde_acima e on
						a.cd_emp = e.cd_emp and    
						a.cd_tbl_desc = e.cd_tbl_desc   
					inner join est_prod_tbl_desc_est_mc b on    
						a.cd_emp = b.cd_emp and    
						a.cd_tbl_desc = b.cd_tbl_desc    
					inner join est_prod_tbl_desc_prc_filial fil on    
						b.cd_emp = fil.cd_emp and    
						b.cd_tbl_desc = fil.cd_tbl_desc    
					inner join rs_est_prod_arv_merc arv on    
						b.cd_emp = arv.cd_emp and    
						b.cd_mc = arv.cd_mc    
					inner join rs_tab_ativa_qtde on    
						a.cd_emp = rs_tab_ativa_qtde.cd_emp and    
						b.cd_tbl_desc = rs_tab_ativa_qtde.cd_tbl_desc        
				where     
						int_cd_filial = fil.cd_filial and
						int_qtde_produto >= e.qtde_acima and
						e.tp_cliente in ( select * from unnest(vr_tp_cliente));
			--raise notice 'perc_desc 3 %', (select perc_desc from temp_rs_tab_desc_qtde limit 1);
			
			
			-------------------------------------------------------------------------------------------------------------------------------    
			--consultando as tbls de desconto para verificar se ha algum desconto no nivel 4 - fabricantes    
			-------------------------------------------------------------------------------------------------------------------------------    
			insert into temp_rs_tab_desc_qtde     
				select   
					a.cd_tbl_desc as cd_tbl_desc,    
					a.cd_tp_desconto as tp_desc,    
					a.flag_desc_fix,    
					b.perc_desc as perc_desc,    
					b.perc_desc_max as perc_desc_max,   
					4 as tp_nivel,
					a.dt_ini     ,
					e.qtde_acima,
					a.flag_aplica_desconto_qtde_multiplo,
					a.flag_agregar_desc_qtde_aos_descontos_existentes
				from est_prod_tbl_desc a
					inner join est_prod_tbl_desc_qtde_acima e on
						a.cd_emp = e.cd_emp and    
						a.cd_tbl_desc = e.cd_tbl_desc   
					inner join est_prod_tbl_desc_est_prod_fabric b on    
						a.cd_emp = b.cd_emp and    
						a.cd_tbl_desc = b.cd_tbl_desc    
					inner join est_prod_tbl_desc_prc_filial fil on    
						b.cd_emp = fil.cd_emp and    
						b.cd_tbl_desc = fil.cd_tbl_desc    
					inner join rs_est_prod_arv_merc arv on    
						b.cd_emp = arv.cd_emp and    
						b.cd_fabric = arv.cd_fabric     
					inner join rs_tab_ativa_qtde on    
						b.cd_emp = rs_tab_ativa_qtde.cd_emp and    
						b.cd_tbl_desc = rs_tab_ativa_qtde.cd_tbl_desc        
				where     
						int_cd_filial = fil.cd_filial and
						int_qtde_produto >= e.qtde_acima and
						e.tp_cliente in ( select * from unnest(vr_tp_cliente));
				--raise notice 'perc_desc 4 %', (select perc_desc from temp_rs_tab_desc_qtde limit 1);
				
				
			------------------------------------------------------------------------------------------------------------------------------    
			--consultando as tbls de desconto para verificar se ha algum desconto no nivel 5 - categorias        
			-------------------------------------------------------------------------------------------------------------------------------    
			insert into temp_rs_tab_desc_qtde     
				select   
					a.cd_tbl_desc as cd_tbl_desc,    
					a.cd_tp_desconto as tp_desc,    
					a.flag_desc_fix,    
					b.perc_desc as perc_desc,    
					b.perc_desc_max as perc_desc_max,   
					5 as tp_nivel,
					a.dt_ini  ,
					e.qtde_acima,
					a.flag_aplica_desconto_qtde_multiplo,
					a.flag_agregar_desc_qtde_aos_descontos_existentes
				from est_prod_tbl_desc a
					inner join est_prod_tbl_desc_qtde_acima e on
						a.cd_emp = e.cd_emp and    
						a.cd_tbl_desc = e.cd_tbl_desc    
					inner join est_prod_tbl_desc_est_arv_merc_categoria b on    
						a.cd_emp = b.cd_emp and    
						a.cd_tbl_desc = b.cd_tbl_desc    
					inner join est_prod_tbl_desc_prc_filial fil on    
						b.cd_emp = fil.cd_emp and    
						b.cd_tbl_desc = fil.cd_tbl_desc    
					inner join rs_est_prod_arv_merc arv on    
						b.cd_emp = arv.cd_emp and    
						b.cd_arv_merc_categ = arv.cd_arv_merc_categ    
					inner join rs_tab_ativa_qtde on    
						a.cd_emp = rs_tab_ativa_qtde.cd_emp and    
						b.cd_tbl_desc = rs_tab_ativa_qtde.cd_tbl_desc        
				where     
						int_cd_filial = fil.cd_filial  and
						int_qtde_produto >= e.qtde_acima and
						e.tp_cliente in ( select * from unnest(vr_tp_cliente));
				--raise notice 'perc_desc 5 %', (select perc_desc from temp_rs_tab_desc_qtde limit 1);
				
				
			-------------------------------------------------------------------------------------------------------------------------------    
			--consultando as tbls de desconto para verificar se ha algum desconto no nivel 6 - linhas
			-------------------------------------------------------------------------------------------------------------------------------    
			insert into temp_rs_tab_desc_qtde     
				select   
					a.cd_tbl_desc as cd_tbl_desc,    
					a.cd_tp_desconto as tp_desc,    
					a.flag_desc_fix,    
					b.perc_desc as perc_desc,    
					b.perc_desc_max as perc_desc_max,   
					6 as tp_nivel,
					a.dt_ini ,
					e.qtde_acima,
					a.flag_aplica_desconto_qtde_multiplo,
					a.flag_agregar_desc_qtde_aos_descontos_existentes
				from est_prod_tbl_desc a
					inner join est_prod_tbl_desc_qtde_acima e on
						a.cd_emp = e.cd_emp and    
						a.cd_tbl_desc = e.cd_tbl_desc    
					inner join est_prod_tbl_desc_est_arv_merc_linha b on    
						a.cd_emp = b.cd_emp and    
						a.cd_tbl_desc = b.cd_tbl_desc    
					inner join est_prod_tbl_desc_prc_filial fil on    
						b.cd_emp = fil.cd_emp and    
						b.cd_tbl_desc = fil.cd_tbl_desc    
					inner join rs_est_prod_arv_merc arv on    
						b.cd_emp = arv.cd_emp and       
						b.cd_arv_merc_linha = arv.cd_arv_merc_linha    
					inner join rs_tab_ativa_qtde on    
						a.cd_emp = rs_tab_ativa_qtde.cd_emp and    
						b.cd_tbl_desc = rs_tab_ativa_qtde.cd_tbl_desc        
				where     
						int_cd_filial = fil.cd_filial and
						int_qtde_produto >= e.qtde_acima and
						e.tp_cliente in ( select * from unnest(vr_tp_cliente));
				--raise notice 'perc_desc 6 %', (select perc_desc from temp_rs_tab_desc_qtde limit 1);
		end if;--if exists (select 1 from rs_tab_ativa_qtde) then
	end if; --if exists (select 1 from rs_est_prod_arv_merc) then
	
	
	
	
	var_desc_multiplo	= (select multiplos 
							 from temp_rs_tab_desc_qtde 
							order by tp_nivel asc, qtde desc, perc_desc  desc,  dt_ini desc limit 1
						   );
	
if var_desc_multiplo = 1  then 
	
	-------------------------------------------------------------------------------------------------------------------------------
	-- retornando desconto limite (resultado da funcao)
	-------------------------------------------------------------------------------------------------------------------------------
	for returnrec in 
	
		select cd_tbl_desc, 
		       tp_desc, 
			   1 flag_desc_fix, 
			   (((cast(int_qtde_produto as integer ) - (cast(int_qtde_produto as integer ) % qtde))) * perc_desc) / (cast(int_qtde_produto as integer )) perc_desc_mult,
			   (((cast(int_qtde_produto as integer ) - (cast(int_qtde_produto as integer ) % qtde))) * perc_desc_max) / (cast(int_qtde_produto as integer )) perc_desc_max_mult,
		 	   tp_nivel,
			   agregacao
		  from temp_rs_tab_desc_qtde 
	     where multiplos  = 1
		 order by tp_nivel asc, qtde desc, perc_desc  desc,  dt_ini desc limit 1
   loop
		return next returnrec;
	end loop;
 
else 

	for returnrec in 
		select cd_tbl_desc, 
		       tp_desc, 
			   1 flag_desc_fix, 
			   perc_desc, 
			   perc_desc_max, 
			   tp_nivel,
			   agregacao
		  from temp_rs_tab_desc_qtde 
		  where multiplos  = 0
	 order by tp_nivel asc, qtde desc,   perc_desc  desc, dt_ini desc limit 1

		 loop
		return next returnrec;
	end loop;
 
end if; 
	
	
				
end; --fim dos blocos da funcao
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
PARALLEL UNSAFE
COST 100 ROWS 1000;

CREATE OR REPLACE FUNCTION public.ufd_est_prod_tbl_desc_qtde(integer, integer, integer, integer, double precision, integer, integer)
RETURNS SETOF public.rs_tab_desc_qtde_acima AS
$body$
DECLARE RET rs_tab_desc_qtde_acima;
BEGIN
  RET = ufd_est_prod_tbl_desc_qtde($1, $2, $3, $4, $5, $6, $7, 0);
  RETURN NEXT RET;
END
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
PARALLEL UNSAFE
COST 100 ROWS 1000;